#!/usr/bin/perl

#
# isdnwatch.pl - watch a GERMAN DSS1 ISDN line on isdn4linux
#                for incoming calls with a certain MSN and caller number
#		 and then run some command on the dial-in server
#
# Author:  Leonhard Fellermayr <leosmail@mac.com>
# History: 17.08.2001 - Initial.

# ----- avoid bugs ;-)

use strict;
use POSIX qw(setsid);

# ----- some global vars

my $msgfile = '/var/log/messages';
my $statusfile = '/tmp/isdnwatch.status';
my $config_file = '/root/bin/isdnwatch.conf';
my $debug = 0;
my $interval = 60;

# ----- sub read_config ($) - read config file into array

sub read_config ($) {
  my $file = shift; 
  open (CONF, "<$file");
  my @config = <CONF>;
  close (CONF);
  my ($entry, $oldentry) = -1;
  my ($key, $value);
  my @conf = ();
  foreach (@config) {
    next if ( (/^$/) or (/^#.*$/) );  
    if (/^\[.*\]$/) {
      $oldentry = $entry;
      $entry++;
      next;
    }
    if ($oldentry ne $entry) {
      chomp ($_);
      ($key, $value) = split /=/, $_;
      $conf[$entry]->{$key} = $value;
    }
  }  
  return (@conf);
}

# ----- sub read_logfile ($) - read syslog file

sub read_logfile ($) {

  my $last_x_lines = shift;	# 0 = read all such lines from log
				# >0 = read last .. lines from log

  # ----- read logged calls from $msgfile

  die "Logfile $msgfile not found, aborting." if (!-e $msgfile);
  open (MSG, "<$msgfile");
  my @msg = grep {/.*call from.*ignored/} <MSG>;
  close (MSG);

  my ($month, $day, $time, @numbers, @other);
  my @all = ();

  # ----- weed out unneeded stuff from log

  my $z = 0;
  my $diff = $#{@msg} + 2 - $last_x_lines;
  foreach (@msg) {
    $z++;
    @numbers = ();
    ($month, $day, $time, @other) = split / /, $_;
    foreach (@other) {
      push @numbers, $_ if ( (/[0-9]/) and not (/^0/) and not (/^$/) );
    }
    next if ($#{@numbers} lt 1);
    foreach (@numbers) {
      $_ =~ s/\n//g;
      $_ =~ s/,.*//g;
    }
    my %newnumbers = (
	CALLER => $numbers[0],
	MSN    => $numbers[1]
    );
    next if ( ($z < $diff) and ($last_x_lines ne 0) );
    push @all, \%newnumbers;
  }

  return (@all);

}

############### main program ###############

chdir '/'                  or die "Can't chdir to /: $!";

umask 0;

open STDIN, '/dev/null'    or die "Can't read /dev/null: $!";
#open STDOUT, '>/dev/null' or die "Can't write to /dev/null: $!";
open STDERR, '>/dev/null'  or die "Can't write to /dev/null: $!";

defined (my $pid = fork)   or die "Can't fork: $!";

exit if $pid;
setsid                     or die "Can't start a new session: $!";

while (1) {
  sleep ($interval);

  # ----- read status file

  open (STATUS, "<$statusfile");
  my $s_lines = <STATUS>;
  chomp ($s_lines);
  close (STATUS);

  # ----- read config and syslog files

  my @config = read_config ($config_file);
  my @logfile = read_logfile (0);

  # ----- check for update necessity

  if ($#{@logfile} eq $s_lines) {
    print "No recent calls!\n" if ($debug);
    next;
  }

  # ----- write new status to our file

  open (STATUS, ">$statusfile");
  print STATUS $#{@logfile};
  close (STATUS);

  # ----- now read only required lines

  my $ll_diff = $#{@logfile} - $s_lines;
  @logfile = read_logfile ($ll_diff);

  # ----- check for desired actions

  my $dowhat = 0;
  foreach my $log (@logfile) {
    foreach my $cfg (@config) {
      if ( ($cfg->{'MSN'} eq $$log{'MSN'}) and ($cfg->{'CALLER'} eq $$log{'CALLER'}) ) {
        $dowhat = 1;
        print "Call from $cfg->{'CALLER'} on MSN $cfg->{'MSN'} -> invoking \"$cfg->{'PROG'}\"\n" if ($debug);
        open (PIPE, "$cfg->{'PROG'} |");
        close (PIPE);
      }
    }
  }

  print "Recent calls, but nothing to do!\n" if ( (!$dowhat) and ($debug) );

}
